//
//  GSTTStem.h
//  GlyphsCore
//
//  Created by Georg Seifert on 09.09.17.
//  Copyright © 2017 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#if !defined(GLYPHS_LITE) && !defined(LIBCORE)
#import <GlyphsCore/GSIdentifiableParameter.h>
#endif

#import <GlyphsCore/GSContainerProtocol.h>

NS_ASSUME_NONNULL_BEGIN

@interface GSTTStem : NSObject /* <GSIdentifiableParameter> */ {

#pragma GSAutoCodeStart ivars

	NSString *_name;
	CGFloat _width;
	BOOL _horizontal;
	NSDictionary *_deltas;
	NSPredicate *_filter;

#pragma GSAutoCodeEnd ivars
}

@property (weak, nonatomic, nullable) GSContainer *parent;

- (instancetype)initWithWidth:(CGFloat)width horizontal:(BOOL)horizontal index:(int)index;

#ifndef GLYPHS_VIEWER
- (nullable NSUndoManager *)undoManager;
#endif

+ (NSDictionary *)swapInstanceKeys:(NSDictionary *)oldDeltas axesCount:(NSUInteger)axesCount toVersion:(GSFormatVersion)toVersion;

#pragma GSAutoCodeStart methods

/// The name.
@property (nonatomic, strong) NSString *name;

/// The width.
@property (nonatomic) CGFloat width;

/// The horizontal.
@property (nonatomic) BOOL horizontal;

/// The deltas.
@property (nonatomic, strong, nullable) NSDictionary *deltas;

/// The filter.
@property (nonatomic, strong) NSPredicate *filter;

#pragma GSAutoCodeEnd methods
@end

NS_ASSUME_NONNULL_END
